<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
   <!--
BOSCH Security Sytems (Ottobrunn)

Project: Magic.Panel

Author: Michael Ziegel

Created: 01.10.2005

$Archive:   //ot1esw2/MagicPanel/PVCS MP-SW/archives/MP_SW/MP_PC_SW/Transformer/Conversion/XSLT/conv-1-0-0-to-1-1-0.xsl-arc  $  

$Revision: 1.7 $ 

Last locked:   $Date: 2011/02/25 15:27:35MEZ $

Last change by $Author: Michael Ziegel (zi82ot) $

History: 
$Log: normalize-1-2-0.xsl  $
Revision 1.7 2011/02/25 15:27:35MEZ Michael Ziegel (zi82ot) 
RemoveAttributes is switchable
Revision 1.6 2007/03/20 13:47:10CET Michael Ziegel (zi82ot) 
Member moved from DownUpTest/normalize-1-2-0.xsl in project f:/MKS_Repository/Fire/MagicPanel/Source/PCTools/Transformer/Transformer.pj to normalize-1-2-0.xsl in project f:/MKS_Repository/Fire/MagicPanel/Source/PCTools/Testing/DownUpTest/DownUpTest.pj.
Revision 1.5 2007/03/20 13:47:10CET Michael Ziegel (zi82ot) 
PRINTER may contain UART or OB_UART
Revision 1.4 2007/01/15 13:34:37CET zi82ot 
Adapted to Network and FSP-structure
Revision 1.3 2006/05/16 16:05:20CEST zi82ot 
AUXPOWER/batteryBackup only used in BCM, can be deleted in all others, sequence-problem
Revision 1.2 2006/04/11 15:50:39CEST zi82ot 
RULE/note and RULE_STATE/note not considered
Revision 1.1 2006/04/11 10:19:19CEST zi82ot 
Initial revision
Member added to project f:/MKS_Repository/Fire/MagicPanel/Source/PCTools/Transformer/Transformer.pj
-->
   <xsl:param name="NotCompared" select="'NOT_COMPARED'"/>
   <xsl:output method="xml" indent="yes"/>
   <!--****************  GENERIC PART iterate thru all nodes and copy elements and attribute ***********************-->
   <!-- copies each node implicitly by match 'node()', the attributes need to be copied explicitly by template @*-->
   <xsl:template match="*">
      <xsl:element name="{name()}">
         <!-- RPS writes newlines into empty elements sometimes -->
         <xsl:choose>
            <xsl:when test="./* = false()">
               <xsl:value-of select="normalize-space(.)"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:apply-templates select="@* | node()"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:element>
   </xsl:template>
   <!-- explicitly copy attributes -->
   <xsl:template match="@*">
      <xsl:copy/>
   </xsl:template>
   <!--****************  SPECIAL PART modifications to certain nodes ***********************-->
   <!--  SET NOT COMPARED begin-->
   <!-- -->
   <xsl:template match="CUSTOMER_INFO/x400">
      <xsl:element name="x400">
         <xsl:value-of select="$NotCompared"/>
      </xsl:element>
   </xsl:template>
   <!-- -->
   <xsl:template match="SUPPORT_INFO/x400">
      <xsl:element name="x400">
         <xsl:value-of select="$NotCompared"/>
      </xsl:element>
   </xsl:template>
   <!-- -->
   <xsl:template match="CONFIG_INFO">
      <xsl:element name="{name()}">
         <xsl:for-each select="child::*">
            <xsl:element name="{name()}">
               <xsl:value-of select="$NotCompared"/>
            </xsl:element>
         </xsl:for-each>
      </xsl:element>
   </xsl:template>
   <!-- delete label MODUL set by panel software-->
   <xsl:template match="label">
      <xsl:element name="{name()}">
         <xsl:choose>
            <xsl:when test="string() = 'Module'">
               <xsl:text/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="."/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:element>
   </xsl:template>
   <!-- delete OPERATOR/pwd-->
   <xsl:template match="OPERATOR/pwd">
  </xsl:template>
   <!-- delete RULE/note-->
   <xsl:template match="RULE/note">
  </xsl:template>
   <!-- delete RULE_STATE/note-->
   
   <!-- delete AUXPOWER/batteryBackup is needed and set in BC_Module only -->
   <!-- delete LSN300_MODULE/AUXPOWER/batteryBackup -->
   <xsl:template match="LSN300_MODULE/AUXPOWER/batteryBackup">
  </xsl:template>
   <!-- delete LSN300_MODULE/AUXPOWER/batteryBackup -->
   <!-- delete AUXPOWER_LSNI_CONV4/batteryBackup -->
   <xsl:template match="AUXPOWER_LSNI_CONV4/batteryBackup">
  </xsl:template>
   <!-- delete AUXPOWER_LSNI_CONV4/batteryBackup -->
   <!-- delete CONVENTIONAL_MODULE/AUXPOWER/batteryBackup -->
   <xsl:template match="CONVENTIONAL_MODULE/AUXPOWER/batteryBackup">
  </xsl:template>
   <!-- delete CONVENTIONAL_MODULE/AUXPOWER/batteryBackup -->
   <!-- delete ENOT_MODULE/AUXPOWER/batteryBackup -->
   <xsl:template match="ENOT_MODULE/AUXPOWER/batteryBackup">
  </xsl:template>
   <!-- delete ENOT_MODULE/AUXPOWER/batteryBackup -->
   <!-- delete NAC_MODULE/AUXPOWER/batteryBackup -->
   <xsl:template match="NAC_MODULE/AUXPOWER/batteryBackup">
  </xsl:template>
   <!-- delete NAC_MODULE/AUXPOWER/batteryBackup -->
   <xsl:template match="RULE_STATE/note">
  </xsl:template>
   <!--  ******** NOT COMPARED ******** end-->
   <!-- ****** RULE DEPTH is TWO ******* begin -->
   <!-- STATUS begin-->
   <xsl:template match="STATUS_ADMIN">
      <xsl:element name="{name()}">
         <xsl:for-each select="STATUS_GROUP">
            <xsl:sort select="siNumber" data-type="number"/>
            <xsl:apply-templates select="."/>
         </xsl:for-each>
      </xsl:element>
   </xsl:template>
   <!-- -->
   <!--   -->
   <xsl:template match="STATUS_GROUP">
      <xsl:element name="{name()}">
         <xsl:element name="siNumber">
            <xsl:value-of select="siNumber"/>
         </xsl:element>
         <xsl:element name="label">
            <xsl:value-of select="label"/>
         </xsl:element>
         <xsl:for-each select="STATUS">
            <xsl:sort select="subNumber" data-type="number"/>
            <xsl:apply-templates select="."/>
         </xsl:for-each>
         <xsl:call-template name="SortWriteRules"/>
      </xsl:element>
   </xsl:template>
   <!--   -->
   <!--   -->
   <xsl:template match="STATUS">
      <xsl:element name="{name()}">
         <xsl:element name="subNumber">
            <xsl:value-of select="subNumber"/>
         </xsl:element>
         <xsl:call-template name="SortWriteRules"/>
      </xsl:element>
   </xsl:template>
   <!-- STATUS  end-->
   <!-- GROUP begin-->
   <xsl:template match="GROUP_ADMIN">
      <xsl:element name="{name()}">
         <xsl:for-each select="GROUP">
            <xsl:sort select="siNumber" data-type="number"/>
            <xsl:apply-templates select="."/>
         </xsl:for-each>
      </xsl:element>
   </xsl:template>
   <!-- -->
   <!--   -->
   <xsl:template match="GROUP">
      <xsl:element name="{name()}">
         <xsl:element name="siNumber">
            <xsl:value-of select="siNumber"/>
         </xsl:element>
         <xsl:element name="label">
            <xsl:value-of select="label"/>
         </xsl:element>
         <xsl:element name="alarmInvestigation">
            <xsl:value-of select="alarmInvestigation"/>
         </xsl:element>
         <xsl:element name="investigationTime">
            <xsl:value-of select="investigationTime"/>
         </xsl:element>
         <xsl:element name="dayNightMode">
            <xsl:value-of select="dayNightMode"/>
         </xsl:element>
         <xsl:for-each select="POINT">
            <xsl:sort select="subNumber" data-type="number"/>
            <xsl:apply-templates select="."/>
         </xsl:for-each>
         <xsl:call-template name="SortWriteRules"/>
      </xsl:element>
   </xsl:template>
   <!--   -->
   <!--   -->
   <xsl:template match="POINT">
      <xsl:element name="{name()}">
         <xsl:element name="subNumber">
            <xsl:value-of select="subNumber"/>
         </xsl:element>
         <xsl:call-template name="SortWriteRules"/>
      </xsl:element>
   </xsl:template>
   <!-- GROUP  end-->
   <!-- NAC_ADMIN begin -->
   <xsl:template match="NAC_ADMIN">
      <xsl:element name="{name()}">
         <xsl:for-each select="NAC_GROUP">
            <xsl:sort select="siNumber" data-type="number"/>
            <xsl:apply-templates select="."/>
         </xsl:for-each>
      </xsl:element>
   </xsl:template>
   <!-- -->
   <!--   -->
   <xsl:template match="NAC_GROUP">
      <xsl:element name="{name()}">
         <xsl:element name="siNumber">
            <xsl:value-of select="siNumber"/>
         </xsl:element>
         <xsl:element name="label">
            <xsl:value-of select="label"/>
         </xsl:element>
         <xsl:for-each select="NAC">
            <xsl:sort select="subNumber" data-type="number"/>
            <xsl:apply-templates select="."/>
         </xsl:for-each>
         <xsl:call-template name="SortWriteRules"/>
      </xsl:element>
   </xsl:template>
   <!--   -->
   <!--   -->
   <xsl:template match="NAC">
      <xsl:element name="{name()}">
         <xsl:element name="subNumber">
            <xsl:value-of select="subNumber"/>
         </xsl:element>
         <xsl:call-template name="SortWriteRules"/>
      </xsl:element>
   </xsl:template>
   <!-- NAC_ADMIN end-->
   <!-- ****** RULE DEPTH is TWO ******* end -->
   <!-- ****** RULE DEPTH is ONE  ******* begin -->
   <!-- SETS begin -->
   <xsl:template match="SETS_ADMIN">
      <xsl:element name="{name()}">
         <xsl:for-each select="SET">
            <xsl:sort select="siNumber" data-type="number"/>
            <xsl:element name="{name()}">
               <xsl:element name="siType">
                  <xsl:value-of select="siType"/>
               </xsl:element>
               <xsl:element name="siNumber">
                  <xsl:value-of select="siNumber"/>
               </xsl:element>
               <xsl:element name="label">
                  <xsl:value-of select="label"/>
               </xsl:element>
               <xsl:for-each select="element">
                  <xsl:sort select="." data-type="text"/>
                  <xsl:apply-templates select="."/>
                  <!--     <xsl:element name="element">
              <xsl:value-of select="."/>
            </xsl:element> -->
               </xsl:for-each>
               <xsl:call-template name="SortWriteRules"/>
            </xsl:element>
         </xsl:for-each>
      </xsl:element>
   </xsl:template>
   <!-- SETS end-->
   <!-- CITYTIE_ADMIN begin -->
   <xsl:template match="CITYTIE_ADMIN">
      <xsl:element name="{name()}">
         <xsl:for-each select="CITYTIE">
            <xsl:sort select="siNumber" data-type="number"/>
            <xsl:element name="{name()}">
               <xsl:element name="siNumber">
                  <xsl:value-of select="siNumber"/>
               </xsl:element>
               <xsl:call-template name="SortWriteRules"/>
            </xsl:element>
         </xsl:for-each>
      </xsl:element>
   </xsl:template>
   <!-- CITYTIE_ADMIN end-->
   <!-- CONTROL_ADMIN begin -->
   <xsl:template match="CONTROL_ADMIN">
      <xsl:element name="{name()}">
         <xsl:for-each select="CONTROL">
            <xsl:sort select="siNumber" data-type="number"/>
            <xsl:element name="{name()}">
               <xsl:element name="siNumber">
                  <xsl:value-of select="siNumber"/>
               </xsl:element>
               <xsl:call-template name="SortWriteRules"/>
            </xsl:element>
         </xsl:for-each>
      </xsl:element>
   </xsl:template>
   <!-- CONTROL_ADMIN end-->
   <!-- DOORHOLDER_ADMIN begin -->
   <xsl:template match="DOORHOLDER_ADMIN">
      <xsl:element name="{name()}">
         <xsl:for-each select="DOORHOLDER">
            <xsl:sort select="siNumber" data-type="number"/>
            <xsl:element name="{name()}">
               <xsl:element name="siNumber">
                  <xsl:value-of select="siNumber"/>
               </xsl:element>
               <xsl:call-template name="SortWriteRules"/>
            </xsl:element>
         </xsl:for-each>
      </xsl:element>
   </xsl:template>
   <!-- DOORHOLDER_ADMIN end-->
   <!-- FIRE_ADMIN begin -->
   <xsl:template match="FIRE_ADMIN">
      <xsl:element name="{name()}">
         <xsl:for-each select="FIRE">
            <xsl:sort select="siNumber" data-type="number"/>
            <xsl:element name="{name()}">
               <xsl:element name="siNumber">
                  <xsl:value-of select="siNumber"/>
               </xsl:element>
               <xsl:call-template name="SortWriteRules"/>
            </xsl:element>
         </xsl:for-each>
      </xsl:element>
   </xsl:template>
   <!-- FIRE_ADMIN end-->
   <!-- KEYDEPOT_ADMIN begin -->
   <xsl:template match="KEYDEPOT_ADMIN">
      <xsl:element name="{name()}">
         <xsl:for-each select="KEYDEPOT">
            <xsl:sort select="siNumber" data-type="number"/>
            <xsl:element name="{name()}">
               <xsl:element name="siNumber">
                  <xsl:value-of select="siNumber"/>
               </xsl:element>
               <xsl:call-template name="SortWriteRules"/>
            </xsl:element>
         </xsl:for-each>
      </xsl:element>
   </xsl:template>
   <!-- KEYDEPOT_ADMIN end-->
   <!-- PRINTER_ADMIN begin -->
   <xsl:template match="PRINTER_ADMIN">
      <xsl:element name="{name()}">
         <xsl:for-each select="PRINTER">
            <xsl:sort select="siNumber" data-type="number"/>
            <xsl:element name="{name()}">
               <xsl:element name="siNumber">
                  <xsl:value-of select="siNumber"/>
               </xsl:element>
               <xsl:element name="label">
                  <xsl:value-of select="label"/>
               </xsl:element>
               <xsl:element name="printerType">
                  <xsl:value-of select="printerType"/>
               </xsl:element>
               <xsl:element name="connectedWith">
                  <xsl:value-of select="connectedWith"/>
               </xsl:element>
               <xsl:if test="UART">
               <xsl:element name="UART">
                  <xsl:apply-templates select="UART"/>
               </xsl:element>
               </xsl:if>
               <xsl:if test="OB_UART">
               <xsl:element name="OB_UART">
                  <xsl:apply-templates select="OB_UART"/>
               </xsl:element>
               </xsl:if>
               <xsl:call-template name="SortWriteRules"/>
            </xsl:element>
         </xsl:for-each>
      </xsl:element>
   </xsl:template>
   <xsl:template match="UART">
         <xsl:element name="number">
            <xsl:value-of select="number"/>
         </xsl:element>
         <xsl:element name="speed">
            <xsl:value-of select="speed"/>
         </xsl:element>
         <xsl:element name="frame">
            <xsl:value-of select="frame"/>
         </xsl:element>
   </xsl:template>
   <xsl:template match="OB_UART">
         <xsl:element name="number">
            <xsl:value-of select="number"/>
         </xsl:element>
         <xsl:element name="speed">
            <xsl:value-of select="speed"/>
         </xsl:element>
         <xsl:element name="frame">
            <xsl:value-of select="frame"/>
         </xsl:element>
         <xsl:element name="irdaEnabled">
            <xsl:value-of select="irdaEnabled"/>
         </xsl:element>
   </xsl:template>
   <!-- PRINTER_ADMIN end-->
   <!-- ********* RULE DEPTH is ONE ********* end -->
   <!-- ****** RULE DEPTH is ZERO  ******* begin -->
   <!--   PANEL_ADMINISTRATION begin -->
   <xsl:template match="PANEL_ADMINISTRATION">
      <xsl:element name="{name()}">
         <xsl:call-template name="SortWriteRules"/>
      </xsl:element>
   </xsl:template>
   <!--   PANEL ADMINISTRATION end -->
   <!-- ****** RULE DEPTH is ZERO ******* end -->
   <!--   ######################################## -->
   <!-- RULES -->
   <xsl:template match="RULE_STATE | RULE">
      <xsl:copy>
         <xsl:apply-templates/>
      </xsl:copy>
   </xsl:template>
   <!--   -->
   <!-- Sorting routines -->
   <xsl:template name="SortWriteRules">
      <xsl:if test="RULE = true()">
         <xsl:call-template name="SortWrite_RULES"/>
      </xsl:if>
      <xsl:if test="RULE_STATE = true()">
         <xsl:call-template name="SortWrite_RULE_STATES"/>
      </xsl:if>
   </xsl:template>
   <!--   -->
   <!--   -->
   <xsl:template name="SortWrite_RULES">
      <xsl:for-each select="RULE/TRIGGER_COUNTER">
         <xsl:sort select="triggerNumber"/>
         <xsl:apply-templates select="../."/>
      </xsl:for-each>
      <xsl:for-each select="RULE/TRIGGER_USER">
         <xsl:sort select="userId"/>
         <xsl:apply-templates select="../."/>
      </xsl:for-each>
      <xsl:for-each select="RULE/TRIGGER_ADMIN">
         <xsl:sort select="command"/>
         <xsl:apply-templates select="../."/>
      </xsl:for-each>
      <xsl:for-each select="RULE/TRIGGER_DOWNLOAD">
         <xsl:sort select="triggerSubject"/>
         <xsl:apply-templates select="../."/>
      </xsl:for-each>
      <xsl:for-each select="RULE/TRIGGER_STATE">
         <xsl:sort select="triggerSubject"/>
         <xsl:apply-templates select="../."/>
      </xsl:for-each>
   </xsl:template>
   <!--  -->
   <xsl:template name="SortWrite_RULE_STATES">
      <xsl:for-each select="RULE_STATE/CONDITION_COUNTER">
         <xsl:sort select="conditionNumber"/>
         <xsl:apply-templates select="../."/>
      </xsl:for-each>
      <xsl:for-each select="RULE_STATE/CONDITION_STATE">
         <xsl:sort select="conditionNumber"/>
         <xsl:apply-templates select="../."/>
      </xsl:for-each>
      <xsl:for-each select="RULE_STATE">
         <!-- special handling for else clauses in state dependend rules, that are RULE_STATE-elements not containing counter or state -->
         <xsl:if test="CONDITION_STATE = false() and CONDITION_COUNTER = false()">
            <xsl:apply-templates select="."/>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>
   <!--   -->
</xsl:stylesheet>
